/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.rsf.sas;

import com.ibm.hwmca.base.rsf.requests.BaseRsfRequestErrorIds;
import com.ibm.hwmca.base.rsf.sas.CredentialCompletionStatus;
import com.ibm.hwmca.base.rsf.sas.CredentialStore;
import com.ibm.hwmca.base.rsf.sas.CredentialUtils;
import com.ibm.hwmca.base.rsf.sas.LocalCredentialStore;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.log.FrameworkLogAttributes;
import com.ibm.hwmca.fw.persist.PersistentData;
import com.ibm.hwmca.fw.schedops.HMCSchedulable;
import com.ibm.hwmca.fw.schedops.OperationTarget;
import com.ibm.hwmca.fw.schedops.Schedulable;
import com.ibm.hwmca.fw.schedops.SchedulableDescriptor;
import com.ibm.hwmca.fw.schedops.SchedulableException;
import com.ibm.hwmca.fw.schedops.ScheduledOperation;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.Trace;

public class ChangePasswordSchedulable
implements HMCSchedulable,
BaseRsfRequestErrorIds {
    private static final String CLASS_NAME = "[ChangePasswordSchedulable] ";
    private static final String TRACE_MASKT = "XRSFSOPT";
    private static final String TRACE_MASKF = "XRSFSOPF";
    private static final String TRACE_MASKD = "XRSFSOPD";
    private static FrameworkClassLogInfo logInfo = new FrameworkClassLogInfo(-44, "System Auth");
    private static FrameworkLogAttributes infoLog = FrameworkLogAttributes.INFO_LOG;
    private SchedulableDescriptor descriptor = null;
    private static String bundleName = "com/ibm/hwmca/base/rsf/res/BaseRsfRes";
    public static boolean canDisplay = false;
    public static boolean retryError = true;

    public ChangePasswordSchedulable() {
        Trace.trace(TRACE_MASKT, "[ChangePasswordSchedulable] <> ChangePasswordSchedulable()");
    }

    protected ChangePasswordSchedulable(PersistentData data) {
        Trace.trace(TRACE_MASKT, "[ChangePasswordSchedulable] <> ChangePasswordSchedulable( PersistentData )");
    }

    public synchronized SchedulableDescriptor getDescriptor() {
        if (this.descriptor == null) {
            this.descriptor = new Descriptor();
        }
        return this.descriptor;
    }

    public Object performScheduledOperation(ScheduledOperation schedop) throws SchedulableException {
        CredentialCompletionStatus status;
        Trace.trace(TRACE_MASKT, "[ChangePasswordSchedulable] >> performScheduledOperation()");
        String[] parms = (String[])schedop.getOperationParameters();
        String credentialStoreName = null;
        String target = null;
        CredentialStore store = null;
        if (parms != null) {
            if (parms.length >= 2) {
                credentialStoreName = parms[1];
            }
            if (parms.length >= 1) {
                target = parms[0];
            }
        }
        if (credentialStoreName != null) {
            try {
                store = CredentialUtils.getCredentialStoreImpl(credentialStoreName);
            }
            catch (Exception e) {
                Trace.trace(TRACE_MASKT, "ChangePasswordSchedulable::performScheduledOperation() exception getting credential store impl");
            }
        }
        if (store == null) {
            store = LocalCredentialStore.getCredentialStore();
        }
        try {
            status = CredentialUtils.updatePasswordSynchronous(target, store);
        }
        catch (Exception e) {
            ChangePasswordSchedulable.logInfo("[ChangePasswordSchedulable] : exception updating password.  Operation cancelled", e, (short)12548);
            return null;
        }
        if (status != null && status.equals(CredentialCompletionStatus.REQUEST_FAILURE)) {
            ChangePasswordSchedulable.logInfo("[ChangePasswordSchedulable] .performScheduledOperation: no credentials for password change. No retry will  will be done.", null, (short)12548);
        } else if (status == null || !status.equals(CredentialCompletionStatus.SUCCESS)) {
            String retryMsg = !retryError ? ". Scheduled operation will not be retried" : ". Will reschedule operation.";
            SchedulableException e = new SchedulableException("Change Password Error");
            ChangePasswordSchedulable.logInfo("[ChangePasswordSchedulable] .performScheduledOperation: Credential completion status=" + status + retryMsg, e, (short)12548);
            if (retryError) {
                throw e;
            }
        }
        Trace.trace(TRACE_MASKT, "[ChangePasswordSchedulable] << performScheduledOperation()");
        return null;
    }

    public PersistentData getPersistentData() {
        return new PersistedData();
    }

    public boolean isUpgradeData() {
        return false;
    }

    public static void logInfo(String errorMsg, Throwable t, short errorId) {
        Trace.trace(TRACE_MASKF, errorMsg);
        FrameworkLog errLog = t != null ? new FrameworkLog(logInfo, errorId, t) : new FrameworkLog(logInfo, errorId);
        errLog.add(errorMsg);
        errLog.log(infoLog);
    }

    public static class Descriptor
    implements SchedulableDescriptor {
        public LocalizableText getDescription() {
            return new LocalizableText(bundleName, "RsfCredentials.Password");
        }

        public Schedulable createSchedulable(OperationTarget target) {
            return new ChangePasswordSchedulable();
        }

        public boolean isDisplayableOnUI(OperationTarget target) {
            return canDisplay;
        }

        public boolean isSelectableOnUI(OperationTarget target) {
            return canDisplay;
        }

        public String getOperationParametersTasklet() {
            return null;
        }
    }

    private static class PersistedData
    implements PersistentData {
        private PersistedData() {
        }
    }
}

